﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class ClassListPanel : AdminPanel
        {
            public ClassListPanel(Administration Component) : base(Component) { }

            public override void Load()
            {
                if (Component.Instructor != null)
                {
                    Component.XML.Element.Start("ClassList");
                    List<BL.BO.Class> _listClass = Component.BLELearning.Class.Restore(Component.Instructor);
                    foreach (BL.BO.Class _loopClass in _listClass)
                    {
                        Component.AppendToXML(_loopClass);
                    }
                    Component.XML.Element.End();
                }
            }

            public override bool Save()
            {
                if (ClassID.HasValue && EditMode == EditModeType.GenerateCertificate)
                {
                    BL.BO.Class _class = Component.BLELearning.Class.RestoreById(ClassID);
                    if (_class != null)
                    {
                        PI.ZB.N1200.ELearning.BL.PDFReport.GenerateClassCert(_class, Component.Environment);
                    }
                }
                return true;
            }
        }
    }
}
